#include <bits/stdc++.h>
using namespace std;

#define N 200001
#define ll long long
vector<int> tree[N];
int boja[N], parent[N];
pair<int, int> que[N];
bool visited[N];
int resenje = 0, oduz = 0;
ll seg[4 * N][3], lazy[4 * N];

void build(int u, int l, int r) {
    if (l == r) {
        seg[u][0] = 1;
        seg[u][1] = boja[l];
        seg[u][2] = boja[l];
        return;
    }
    int mid = l + r >> 1;
    build(u * 2 + 1, l, mid);
    build(u * 2 + 2, mid + 1, r);
    seg[u][0] = seg[u * 2 + 1][0] + seg[u * 2 + 2][0];
    if (seg[u*2+1][2] == seg[u*2+2][1])
        seg[u][0]--;
    seg[u][1] = seg[u*2+1][1];
    seg[u][2] = seg[u*2+2][2];
}

void update1(int u, int x) {
    lazy[u] = x;
    seg[u][0] = 1;
    seg[u][1] = x;
    seg[u][2] = x;
}

void shift(int u) {
    if (!lazy[u])
        return;
    update1(u * 2 + 1, lazy[u]);
    update1(u * 2 + 2, lazy[u]);
    lazy[u] = 0;
}

void update(int u, int L, int R, int l, int r, int x) {
    if (l > R || r < L)
        return;
    if (l >= L && r <= R) {
        update1(u, x);
        return;
    }
    shift(u);
    int mid = l + r >> 1;
    update(u * 2 + 1, L, R, l, mid, x);
    update(u * 2 + 2, L, R, mid + 1, r, x);
    seg[u][0] = seg[u * 2 + 1][0] + seg[u * 2 + 2][0];
    if (seg[u*2+1][2] == seg[u*2+2][1])
        seg[u][0]--;
    seg[u][1] = seg[u*2+1][1];
    seg[u][2] = seg[u*2+2][2];
}

bool niz(int n) {
    for (int i = 0; i < n; i++) {
        for (auto j = tree[i].begin(); j != tree[i].end(); j++) {
            if (*j != i - 1 && *j != i + 1)
                return false;
        }
    }
    return true;
}

bool svakaizmena(int n) {
    int b = que[0].second;
    for (int i = 1; i < n; i++) {
        if (que[i].second != b)
            return false;
    }
    return true;
}

void resetvisited(int n) {
    for (int i = 0; i < n; i++)
        visited[i] = false;
}

void nadjiparent(int u) {
    visited[u] = true;
    for (auto i = tree[u].begin(); i != tree[u].end(); i++) {
        if (!visited[*i]) {
            parent[*i] = u;
            nadjiparent(*i);
        }
    }
}

void fusdfs(int u) {
    if (u == 0 || boja[u] != boja[parent[u]])
        resenje++;
    for (auto i = tree[u].begin(); i != tree[u].end(); i++) {
        if (*i != parent[u]) {
            fusdfs(*i);
        }
    }
}

void fusupdate(int u, int c) {
    boja[u] = c;
    for (auto i = tree[u].begin(); i != tree[u].end(); i++) {
        if (*i != parent[u]) {
            fusupdate(*i, c);
        }
    }
}

void fusupdate1(int u, int c) {
    boja[u] = c;
    visited[u] = true;
    for (auto i = tree[u].begin(); i != tree[u].end(); i++) {
        if (*i != parent[u]) {
            fusupdate1(*i, c);
        }
    }
}

void fusdfs1(int u) {
    if (u == 0 || boja[u] != boja[parent[u]])
        oduz++;
    for (auto i = tree[u].begin(); i != tree[u].end(); i++) {
        if (visited[*i]) {
            if (boja[*i] != boja[parent[*i]])
                oduz++;
            continue;
        }
        if (*i != parent[u]) {
            fusdfs1(*i);
        }
    }
}

void solve() {
    int n, q;
    cin >> n >> q;
    for (int i = 1; i < n; i++) {
        int l, r;
        cin >> l >> r;
        l--;
        r--;
        tree[l].push_back(r);
        tree[r].push_back(l);
    }
    for (int i = 0; i < n; i++) {
        cin >> boja[i];
    }
    for (int i = 0; i < q; i++) {
        cin >> que[i].first >> que[i].second;
    }
    nadjiparent(0);
    if (n <= 1000 && q <= 1000) {
        for (int i = 0; i < q; i++) {
            int u = que[i].first, c = que[i].second;
            fusupdate(u - 1, c);
            resenje = 0;
            fusdfs(0);
            cout << resenje << endl;
        }
        return;
    }
    if (svakaizmena(q)) {
        resetvisited(n);
        int c = que[0].second;
        fusdfs(0);
        for (int i = 0; i < q; i++) {
            int u = que[i].first - 1;
            oduz = 0;
            fusdfs1(u);
            if (c == boja[parent[u]])
                oduz += 1;
            fusupdate1(u, c);
            resenje = resenje - oduz + 1;
            cout << resenje << endl;
        }
        return;
    }
    if (niz(n)) {
        build(0, 0, n - 1);
        for (int i = 0; i < q; i++) {
            update(0, que[i].first - 1, n - 1, 0, n - 1, que[i].second);
            cout << seg[0][0] << endl;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    solve();
    return 0;
}


/*
6 4
1 2
2 3
3 4
4 5
5 6
1 2 1 1 3 3
4 3
4 2
1 1
2 2*/